import json


class Config_loader:
    def __init__(self, config_file_path: str):
        with open(config_file_path, "r", encoding="utf-8") as file_obj:
            json_data = json.load(file_obj)
            # jsonデータのチェック処理を挟む
            self._config_dict = json_data

    def get_config_dict(self):
        return self._config_dict

    def exist_rules(self):
        return "rules" in self._config_dict

    def get_enabled_rules_dict(self):
        dict = {}
        for rule_name in self._config_dict["rules"]:
            value = self._config_dict["rules"][rule_name]
            if value is not False:
                rule_config_dict = value
                if rule_config_dict["enabled"]:
                    dict[rule_name] = rule_config_dict
        return dict
